/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CraftingPattern
implements ICraftingPattern {
    private final ItemStack stack;
    private final boolean processing;
    private final boolean oredict;
    private boolean valid;
    private IRecipe recipe;
    private final List<NonNullList<ItemStack>> inputs = new ArrayList<NonNullList<ItemStack>>();
    private final NonNullList<ItemStack> outputs = NonNullList.func_191196_a();
    private NonNullList<ItemStack> byproducts = NonNullList.func_191196_a();
    private final NonNullList<FluidStack> fluidInputs = NonNullList.func_191196_a();
    private final NonNullList<FluidStack> fluidOutputs = NonNullList.func_191196_a();
    private final NonNullList<ItemStack> blacklistedItems = NonNullList.func_191196_a();
    private final NonNullList<FluidStack> blacklistedFluids = NonNullList.func_191196_a();
    private final int cachedHashCode;

    public CraftingPattern(World world, ItemStack stack) {
        this.stack = stack.func_77946_l();
        this.processing = ItemPattern.isProcessing(stack);
        this.oredict = ItemPattern.isOredict(stack);
        IStackList<ItemStack> itemInputCounts = API.instance().createItemStackList();
        IStackList<FluidStack> fluidInputCounts = API.instance().createFluidStackList();
        IStackList<ItemStack> itemOutputCounts = API.instance().createItemStackList();
        IStackList<FluidStack> fluidOutputCounts = API.instance().createFluidStackList();
        if (this.processing) {
            for (int i = 0; i < 9; ++i) {
                FluidStack fluidOutput;
                FluidStack fluidInput;
                ItemStack input = ItemPattern.getInputSlot(stack, i);
                if (input != null && !input.func_190926_b()) {
                    itemInputCounts.add(input);
                }
                if (input == null) {
                    this.inputs.add((NonNullList<ItemStack>)NonNullList.func_191196_a());
                } else if (this.oredict) {
                    NonNullList ores = NonNullList.func_191196_a();
                    int[] oreIDs = OreDictionary.getOreIDs((ItemStack)input);
                    if (oreIDs.length == 0) {
                        ores.add((Object)input.func_77946_l());
                    }
                    for (int id : oreIDs) {
                        String name = OreDictionary.getOreName((int)id);
                        for (ItemStack ore : OreDictionary.getOres((String)name)) {
                            if (ore.func_77960_j() == Short.MAX_VALUE) {
                                ore.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, ores);
                                continue;
                            }
                            ores.add((Object)ore.func_77946_l());
                        }
                    }
                    Object object = ores.iterator();
                    while (object.hasNext()) {
                        ItemStack ore = (ItemStack)object.next();
                        ore.func_190920_e(input.func_190916_E());
                    }
                    this.inputs.add((NonNullList<ItemStack>)ores);
                } else {
                    this.inputs.add((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{input}));
                }
                ItemStack output = ItemPattern.getOutputSlot(stack, i);
                if (output != null) {
                    this.valid = true;
                    itemOutputCounts.add(output);
                    this.outputs.add((Object)output);
                }
                if ((fluidInput = ItemPattern.getFluidInputSlot(stack, i)) != null) {
                    this.valid = true;
                    fluidInputCounts.add(fluidInput);
                    this.fluidInputs.add((Object)fluidInput);
                }
                if ((fluidOutput = ItemPattern.getFluidOutputSlot(stack, i)) == null) continue;
                this.valid = true;
                fluidOutputCounts.add(fluidOutput);
                this.fluidOutputs.add((Object)fluidOutput);
            }
        } else {
            InventoryCraftingDummy inv = new InventoryCraftingDummy();
            for (int i = 0; i < 9; ++i) {
                ItemStack input = ItemPattern.getInputSlot(stack, i);
                this.inputs.add((NonNullList<ItemStack>)(input == null ? NonNullList.func_191196_a() : NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{input})));
                if (input == null) continue;
                inv.func_70299_a(i, input);
            }
            for (IRecipe r : CraftingManager.field_193380_a) {
                if (!r.func_77569_a((InventoryCrafting)inv, world)) continue;
                this.recipe = r;
                this.byproducts = this.recipe.func_179532_b((InventoryCrafting)inv);
                ItemStack output = this.recipe.func_77572_b((InventoryCrafting)inv);
                if (output.func_190926_b()) break;
                this.valid = true;
                this.outputs.add((Object)output);
                if (!this.oredict) break;
                if (!this.recipe.func_192400_c().isEmpty()) {
                    this.inputs.clear();
                    for (int i = 0; i < this.recipe.func_192400_c().size(); ++i) {
                        this.inputs.add(i, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((Ingredient)this.recipe.func_192400_c().get(i)).func_193365_a()));
                    }
                } else {
                    this.valid = false;
                }
                break;
            }
        }
        itemInputCounts.getStacks().forEach(e -> {
            StackListEntry entry = itemOutputCounts.getEntry((ItemStack)e.getStack(), 3);
            if (entry != null && e.getCount() >= entry.getCount()) {
                this.blacklistedItems.add(e.getStack());
            }
        });
        fluidInputCounts.getStacks().forEach(e -> {
            StackListEntry entry = fluidOutputCounts.getEntry((FluidStack)e.getStack(), 3);
            if (entry != null && e.getCount() >= entry.getCount()) {
                this.blacklistedFluids.add(e.getStack());
            }
        });
        if (!this.isProcessing()) {
            this.blacklistedItems.clear();
            this.blacklistedFluids.clear();
        }
        if (this.blacklistedFluids.size() == this.fluidOutputs.size() && this.blacklistedItems.size() == this.inputs.size()) {
            this.valid = false;
        }
        this.cachedHashCode = this.getHashCode();
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public boolean isOredict() {
        return this.oredict;
    }

    @Override
    public List<NonNullList<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public ItemStack getOutput(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get crafting output from processing pattern");
        }
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        InventoryCraftingDummy inv = new InventoryCraftingDummy();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        ItemStack result = this.recipe.func_77572_b((InventoryCrafting)inv);
        if (result.func_190926_b()) {
            throw new IllegalStateException("Cannot have empty result");
        }
        return result;
    }

    @Override
    public NonNullList<ItemStack> getByproducts() {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        return this.byproducts;
    }

    @Override
    public NonNullList<ItemStack> getByproducts(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        if (took.size() != this.inputs.size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.size() + ")");
        }
        InventoryCraftingDummy inv = new InventoryCraftingDummy();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        NonNullList remainingItems = this.recipe.func_179532_b((InventoryCrafting)inv);
        NonNullList sanitized = NonNullList.func_191196_a();
        for (ItemStack item : remainingItems) {
            if (item.func_190926_b()) continue;
            sanitized.add((Object)item);
        }
        return sanitized;
    }

    @Override
    public NonNullList<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    @Override
    public NonNullList<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Override
    public NonNullList<ItemStack> getBlacklistedItems() {
        return this.blacklistedItems;
    }

    @Override
    public NonNullList<FluidStack> getBlacklistedFluids() {
        return this.blacklistedFluids;
    }

    @Override
    public String getId() {
        return "v8";
    }

    @Override
    public boolean canBeInChainWith(ICraftingPattern other) {
        int i;
        if (other.isProcessing() != this.processing || other.isOredict() != this.oredict) {
            return false;
        }
        if (other.getInputs().size() != this.inputs.size() || other.getFluidInputs().size() != this.fluidInputs.size() || other.getOutputs().size() != this.outputs.size() || other.getFluidOutputs().size() != this.fluidOutputs.size()) {
            return false;
        }
        if (!this.processing && other.getByproducts().size() != this.byproducts.size()) {
            return false;
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            List inputPossibilities = (List)this.inputs.get(i);
            List otherInputs = (List)other.getInputs().get(i);
            if (inputPossibilities.size() != otherInputs.size()) {
                return false;
            }
            for (int j = 0; j < inputPossibilities.size(); ++j) {
                if (API.instance().getComparer().isEqual((ItemStack)inputPossibilities.get(j), (ItemStack)otherInputs.get(j))) continue;
                return false;
            }
        }
        for (i = 0; i < this.fluidInputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((FluidStack)this.fluidInputs.get(i), (FluidStack)other.getFluidInputs().get(i), 6)) continue;
            return false;
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((ItemStack)this.outputs.get(i), (ItemStack)other.getOutputs().get(i))) continue;
            return false;
        }
        for (i = 0; i < this.fluidOutputs.size(); ++i) {
            if (API.instance().getComparer().isEqual((FluidStack)this.fluidOutputs.get(i), (FluidStack)other.getFluidOutputs().get(i), 6)) continue;
            return false;
        }
        if (!this.processing) {
            for (i = 0; i < this.byproducts.size(); ++i) {
                if (API.instance().getComparer().isEqual((ItemStack)this.byproducts.get(i), (ItemStack)other.getByproducts().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int getHashCode() {
        int result = this.processing ? 1 : 0;
        result = 31 * result + (this.oredict ? 1 : 0);
        for (List list : this.inputs) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getItemStackHashCode(input);
            }
        }
        for (FluidStack fluidStack : this.fluidInputs) {
            result = 31 * result + API.instance().getFluidStackHashCode(fluidStack);
        }
        for (ItemStack itemStack : this.outputs) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        for (FluidStack fluidStack : this.fluidOutputs) {
            result = 31 * result + API.instance().getFluidStackHashCode(fluidStack);
        }
        for (ItemStack itemStack : this.byproducts) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        return result;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftingPattern) {
            return this.canBeInChainWith((CraftingPattern)obj);
        }
        return false;
    }

    public String toString() {
        return "CraftingPattern{processing=" + this.processing + ", oredict=" + this.oredict + ", valid=" + this.valid + ", recipe=" + this.recipe + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", byproducts=" + this.byproducts + ", fluidInputs=" + this.fluidInputs + ", fluidOutputs=" + this.fluidOutputs + ", blacklistedItems=" + this.blacklistedItems + ", blacklistedFluids=" + this.blacklistedFluids + '}';
    }

    private static class InventoryCraftingDummy
    extends InventoryCrafting {
        public InventoryCraftingDummy() {
            super(new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer player) {
                    return true;
                }
            }, 3, 3);
        }
    }
}

